/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPAddress;
import apicore.message.IPCEventLTV;
import apicore.message.IPV6Address;
import apiipc.generated.enums.IPV6AddressType;
import apiipc.ipc.IPCEvent;

public abstract class HostPortEvent
extends IPCEvent {
    public EventType type;

    public HostPortEvent(IPCEventLTV iPCEventLTV) {
        super(iPCEventLTV);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        IP_CHANGED,
        IPV6LINK_LOCAL_CHANGED,
        IPV6ADDRESS_ADDED,
        IPV6ADDRESS_REMOVED;

    }

    public static class Ipv6AddressRemoved
    extends HostPortEvent {
        public IPV6Address ipAddress;
        public Integer prefix;
        public IPV6AddressType inType;

        public Ipv6AddressRemoved(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.IPV6ADDRESS_REMOVED;
            this.ipAddress = (IPV6Address)iPCEventLTV.getEventParameters().get(0);
            this.prefix = (Integer)iPCEventLTV.getEventParameters().get(1);
            this.inType = IPV6AddressType.fromIntValue((Integer)iPCEventLTV.getEventParameters().get(2));
        }

        public String toString() {
            return super.toString() + "\n\tipAddress = " + this.ipAddress + "\n\tprefix = " + this.prefix + "\n\tinType = " + (Object)((Object)this.inType);
        }
    }

    public static class Ipv6AddressAdded
    extends HostPortEvent {
        public IPV6Address ipAddress;
        public Integer prefix;
        public IPV6AddressType inType;

        public Ipv6AddressAdded(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.IPV6ADDRESS_ADDED;
            this.ipAddress = (IPV6Address)iPCEventLTV.getEventParameters().get(0);
            this.prefix = (Integer)iPCEventLTV.getEventParameters().get(1);
            this.inType = IPV6AddressType.fromIntValue((Integer)iPCEventLTV.getEventParameters().get(2));
        }

        public String toString() {
            return super.toString() + "\n\tipAddress = " + this.ipAddress + "\n\tprefix = " + this.prefix + "\n\tinType = " + (Object)((Object)this.inType);
        }
    }

    public static class Ipv6LinkLocalChanged
    extends HostPortEvent {
        public IPV6Address newIp;
        public IPV6Address oldIp;

        public Ipv6LinkLocalChanged(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.IPV6LINK_LOCAL_CHANGED;
            this.newIp = (IPV6Address)iPCEventLTV.getEventParameters().get(0);
            this.oldIp = (IPV6Address)iPCEventLTV.getEventParameters().get(1);
        }

        public String toString() {
            return super.toString() + "\n\tnewIp = " + this.newIp + "\n\toldIp = " + this.oldIp;
        }
    }

    public static class IpChanged
    extends HostPortEvent {
        public IPAddress newIp;
        public IPAddress newMask;
        public IPAddress oldIp;
        public IPAddress oldMask;

        public IpChanged(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.IP_CHANGED;
            this.newIp = (IPAddress)iPCEventLTV.getEventParameters().get(0);
            this.newMask = (IPAddress)iPCEventLTV.getEventParameters().get(1);
            this.oldIp = (IPAddress)iPCEventLTV.getEventParameters().get(2);
            this.oldMask = (IPAddress)iPCEventLTV.getEventParameters().get(3);
        }

        public String toString() {
            return super.toString() + "\n\tnewIp = " + this.newIp + "\n\tnewMask = " + this.newMask + "\n\toldIp = " + this.oldIp + "\n\toldMask = " + this.oldMask;
        }
    }
}

